package net.minecraft.src;

import java.util.ArrayList;
import java.util.Random;

public class WaveSpawner
{
	public static int points = 0;
	public static void spawnWave(TileEntityShrine shrine)
	{
		int wave = shrine.waveCount;
		points = (int) (50*wave*mod_Mine4Dead.getDifficultyRating(shrine.worldObj)*((float)(shrine.worldObj.rand.nextInt(21))+90F)/100F);
		ArrayList<EntityM4DMob> mobList = new ArrayList<EntityM4DMob>();
		int[] quantity = positive(getQuantityValues(wave)); 
		int x = shrine.xCoord + shrine.worldObj.rand.nextInt(101)-50;
		if (x>=0)
		{
			x+=50;
		}
		else
		{
			x-=50;
		}
		int z = shrine.zCoord + shrine.worldObj.rand.nextInt(201)-100;
		if (z>=0)
		{
			z+=50;
		}
		else
		{
			z-=50;
		}
		int y = 128;
		while (y > 0)
		{
			if (shrine.worldObj.getBlockId(x, y-1, z)!=0)
			{
				break;
			}
			y--;
		}
		System.out.println("Wave at "+x+"/"+y+"/"+z);
		while (points>0)
		{
			String mobname = getRandomMob(wave, quantity, shrine.worldObj.rand);
			World world = shrine.worldObj;
			EntityLiving mob = (EntityLiving)EntityList.createEntityInWorld(mobname, world);
	    	if (mob == null)
	    	{
	    		continue;
	    	}
	        mobList.add((EntityM4DMob) mob);
		}
		shrine.waveSpawner=new WaveSpawner(x,y,z,shrine,mobList);
		ModLoader.getMinecraftInstance().ingameGUI.addChatMessage("WAVE "+wave+" INBOUND! Coordinates: "+x+"/"+z+"  Prepare to fight!");
	}
	
	public static int[] getQuantityValues(int wave)
	{
		if (wave>1)
		{
			int[] array = getQuantityValues(wave-1);
			array[0]++;
			array[1]++;
			if (wave>2)
			{
				array[2]+=2;
				array[3]+=1;
				if (wave>3)
				{
					array[4]+=2;
					array[5]+=1;
					if (wave>4)
					{
						array[0]--;
						array[1]--;
						if (wave>5)
						{
							array[6]+=1;
							array[7]+=2;
							if (wave>6)
							{
								array[8]+=1;
								array[9]+=2;
								array[1]-=3;
								if (wave>7)
								{
									array[0]-=3;
									array[2]+=1;
								}
							}
						}
					}
				}
			}
			return array;
		}
		else
		{
			int[] array = new int[20];
			array[0]+=5;
			array[1]+=5;
			return array;
		}
	}
	
	public static int[] positive(int[] ints)
	{
		for (int i = 0; i < ints.length; i++)
		{
			ints[i]=Math.abs(ints[i]);
		}
		return ints;
	}
	
	public static String getRandomMob(int wave, int[] quantity, Random random)
	{
		int sum= 0;
		for (int i=0; i < quantity.length; i++)
		{
			sum+=quantity[i];
		}
		int number = random.nextInt(sum+1);
		int index = 0;
		while (number > 0)
		{
			number-=quantity[index];
			if (number>0 && index<mobNameList.length)
			{
				index++;
			}
			else
			{
				break;
			}
		}
		points-=mobValue[index];
		return mobNameList[index];
	}
	
	public WaveSpawner(int xx, int yy, int zz, TileEntityShrine shrinee, ArrayList<EntityM4DMob> list)
	{
		x=xx;
		y=yy;
		z=zz;
		shrine=shrinee;
		mobList=list;
	}
	public int x;
	public int y;
	public int z;
	public TileEntityShrine shrine;
	public ArrayList<EntityM4DMob> mobList;
	public boolean done = false;
	public ArrayList<EntityM4DMob> activeMobs = new ArrayList<EntityM4DMob>();
	
	public void spawn(EntityM4DMob mob)
	{
		World world = shrine.worldObj;
		float f1 = ((float)x+world.rand.nextInt(21)-10);
    	float f2 = ((float)y);
        float f3 = ((float)z+world.rand.nextInt(21)-10);
        mob.setLocationAndAngles(f1, f2, f3, world.rand.nextFloat() * 360F, 0.0F);
        if (world.rand.nextInt(10)==0)
        {
        	mob.spawnExplosionParticle();
        }
        world.entityJoinedWorld(mob);
	}
	
	public void update()
	{
		checkMobsAlive(activeMobs);
		if (activeMobs.size()<=10)
		{
			if (mobList.size()>0)
			{
				fillUp();
			}
			if (activeMobs.size()==0)
			{
				done=true;
			}
		}
	}
	
	 public void checkMobsAlive(ArrayList<EntityM4DMob> list)
	    {
	    	for (int i = 0; i < list.size(); i++)
	    	{
	    		if (list.get(i).isDead)
	    		{
	    			mod_Mine4Dead.score(list.get(i).value);
	    			list.remove(i);
	    			i--;
	    		}
	    	}
	    }
	
	public void fillUp()
	{
		while (mobList.size()>0 && activeMobs.size()<mod_Mine4Dead.mobLimit)
		{
			EntityM4DMob mob = mobList.get(0);
			mobList.remove(0);
			activeMobs.add(mob);
			spawn(mob);
		}
	}
	
	public int countAll()
	{
		return mobList.size()+activeMobs.size();
	}
	
	public boolean teleportMobHere(int i, int j, int k)
	{
		if (activeMobs.size()==0)
		{
			return false;
		}
		EntityM4DMob mob = activeMobs.get(0);
		mob.spawnExplosionParticle();
		mob.teleport(i, j+1, k);
		mob.spawnExplosionParticle();
		return true;
	}
	
	public static final String[] mobNameList = new String[] {"Walking Dead", "Crawl Spider", "Corrupted Corpse", "Mad Cow", "Dirt Eater", "Crazy Chicken", "Dark Zombie", "Buster", "Corruptor", "Webbing Spider"};
	public static final int[] mobValue = new int[] {1,1,2,2,3,2,4,4,5,4};
}
